Unit ViewZip;

{$F+,O+,X+,S-(*,D-*)}

interface

uses Objects, Views, Dos, Dialogs, Archives;

type

  { TZipLineCollection }

  PZipLineCollection = ^TZipLineCollection;
  TZipLineCollection = object(TCollection)
    procedure FreeItem(P: Pointer); virtual;
  end;

  { TZipViewer }

  PZipViewer = ^TZipViewer;
  TZipViewer = object(TScroller)
    ZipFileName: PString;
    ZipLines: PCollection;
    IsValid: Boolean;
    constructor Init(var Bounds: TRect; AHScrollBar, AVScrollBar: PScrollBar;
      const AZipFileName: PathStr);
{}   constructor Load(var S: TStream);{}
    destructor Done; virtual;
    procedure Draw; virtual;
    procedure ReadFile(const FName: PathStr);
    procedure ZipViewerAP(FileText: PathStr;
                          FTimeDate, FSize: LongInt;
                          FAttr: Word;
                          ArcType: TArchiveType;
                          ArcLevel: Integer); virtual;
    procedure SetState(AState: Word; Enable: Boolean); virtual;
{}   procedure Store(var S: TStream);{}
    function Valid(Command: Word): Boolean; virtual;
  end;

  { TZipWindow }

  PZipWindow = ^TZipWindow;
  TZipWindow = object(TWindow)
    constructor Init(R: TRect; const ZipFileName: PathStr);
  end;

  { TZipDialog }

  PZipDialog = ^TZipDialog;
  TZipDialog = object(TDialog)
    constructor Init(R: TRect; const ZipFileName: PathStr);
  end;

(**)
const

  RZipViewer: TStreamRec = (
     ObjType: 10080;
     VmtLink: Ofs(TypeOf(TZipViewer)^);
     Load:    @TZipViewer.Load;
     Store:   @TZipViewer.Store
  );
  RZipWindow: TStreamRec = (
     ObjType: 10081;
     VmtLink: Ofs(TypeOf(TZipWindow)^);
     Load:    @TZipWindow.Load;
     Store:   @TZipWindow.Store
  );

procedure RegisterZViewer;
(**)

implementation

uses Drivers, Memory, MsgBox, App;

var
  GenZipLines: PCollection;

procedure GeneralAP(FileText: PathStr;
                    FTimeDate, FSize: LongInt;
                    FAttr: Word;
                    ArcType: TArchiveType;
                    ArcLevel: Integer);
var
  FileInfo: PathStr;
  DT: DateTime;

  function IntToString(Num, Width: Integer): PathStr;
  { Changes an integer into a string }
  var
    TempString : PathStr;
  begin
    Str(Num:Width, TempString);
    IntToString := TempString;
  end; { IntToString }

  function IntToPadString(Num, Width: Integer): PathStr;
  { Changes an integer into a string and pads it with a zero on the left if
    it is less than 10 }
  begin
    if Num < 10 then
      IntToPadString := '0' + IntToString(Num, Width)
    else
      IntToPadString := IntToString(Num, Width);
  end; { IntToString }

  function FileDateString(Date: DateTime): PathStr;
  begin
    with Date do
      FileDateString := IntToString(Day, 2) + '/' +
                        IntToPadString(Month, 1) + '/' +
                        IntToString(Year, 4);
  end;  { FileDateString }

  function FileTimeString(Time : DateTime): PathStr;
  begin
    with Time do
      FileTimeString := IntToString(Hour, 2) + ':' +
                        IntToPadString(Min, 1);
  end;  { FileTimeString }

  function FileSizeString(Size : LongInt): PathStr;
  var
    TempString : PathStr;
  begin
    Str(Size:7, TempString);
    FileSizeString := TempString;
  end;  { FileSizeString }

begin
  if GenZipLines <> NIL then begin
    UnPackTime(FTimeDate, DT);
    FileInfo := FileTimeString(DT) + ' ' +
                FileDateString(DT) + ' ' +
                FileSizeString(FSize) + ' ' +
                FileText;
    GenZipLines^.Insert(NewStr(FileInfo));
  end;
end;

{ TZipCollection }
procedure TZipLineCollection.FreeItem(P: Pointer);
begin
  DisposeStr(P);
end;

{ TZipViewer }
constructor TZipViewer.Init(var Bounds: TRect; AHScrollBar,
  AVScrollBar: PScrollBar; const AZipFileName: PathStr);
begin
  TScroller.Init(Bounds, AHScrollbar, AVScrollBar);
  GrowMode := gfGrowHiX + gfGrowHiY;
  ZipFileName := nil;
  ReadFile(AZipFileName);
end;

constructor TZipViewer.Load(var S: TStream);
var
  FName: PathStr;
begin
  TScroller.Load(S);
  ZipFileName := S.ReadStr;
  FName := ZipFileName^;
  ReadFile(FName);
end;

destructor TZipViewer.Done;
begin
  Dispose(ZipLines, Done);
  DisposeStr(ZipFileName);
  TScroller.Done;
end;

procedure TZipViewer.Draw;
var
  B: TDrawBuffer;
  C: Byte;
  I: Integer;
  S: String;
  P: PString;
begin
{ C := GetColor(1);}
  C := $1E;                        {Yellow on Blue}
  for I := 0 to Size.Y - 1 do
  begin
    MoveChar(B, ' ', C, Size.X);
    if Delta.Y + I < ZipLines^.Count then
    begin
      P := ZipLines^.At(Delta.Y + I);
      if P <> nil then S := Copy(P^, Delta.X + 1, Size.X)
      else S := '';
      MoveStr(B, S, C);
    end;
    WriteLine(0, I, Size.X, 1, B);
  end;
end;

procedure TZipViewer.ZipViewerAP(FileText: PathStr;
                                 FTimeDate, FSize: LongInt;
                                 FAttr: Word;
                                 ArcType: TArchiveType;
                                 ArcLevel: Integer);
begin
  ZipLines^.Insert(NewStr(FileText));
end;

procedure TZipViewer.ReadFile(const FName: PathStr);
begin
  IsValid := True;
  if ZipFileName <> nil then DisposeStr(ZipFileName);
  ZipFileName := NewStr(FName);
  ZipLines := New(PZipLineCollection, Init(5,5));
  if pos('.ZIP', ZipFileName^) > 0 then
  begin
{   ProcessThisZipFile(FName, ZipViewerAP);}
    if GenZipLines = NIL then
    begin
      GenZipLines := ZipLines;  {make public for GeneralAP}
      ProcessThisZipFile(FName, GeneralAP);
      GenZipLines := NIL;
    end;
  end else if pos('.ARJ', ZipFileName^) > 0 then
  begin
{   ProcessThisArjFile(FName, ZipViewerAP);}
    if GenZipLines = NIL then
    begin
      GenZipLines := ZipLines;  {make public for GeneralAP}
      ProcessThisArjFile(FName, GeneralAP);
      GenZipLines := NIL;
    end;
  end else if pos('.ARC', ZipFileName^) > 0 then
  begin
{   ProcessThisArcFile(FName, ZipViewerAP);}
    if GenZipLines = NIL then
    begin
      GenZipLines := ZipLines;  {make public for GeneralAP}
      ProcessThisArcFile(FName, GeneralAP);
      GenZipLines := NIL;
    end;
  end else if pos('.LZH', ZipFileName^) > 0 then
  begin
{   ProcessThisLzhFile(FName, ZipViewerAP);}
    if GenZipLines = NIL then
    begin
      GenZipLines := ZipLines;  {make public for GeneralAP}
      ProcessThisLzhFile(FName, GeneralAP);
      GenZipLines := NIL;
    end;
  end;
{ Limit.X := MaxWidth;}
  Limit.Y := ZipLines^.Count;
end;

procedure TZipViewer.SetState(AState: Word; Enable: Boolean);
begin
  TScroller.SetState(AState, Enable);
  if Enable and (AState and sfExposed <> 0) then
     SetLimit(Limit.X, Limit.Y);
end;

procedure TZipViewer.Store(var S: TStream);
begin
  TScroller.Store(S);
  S.WriteStr(ZipFileName);
end;

function TZipViewer.Valid(Command: Word): Boolean;
begin
  Valid := IsValid;
end;

{ TTextWindow }
constructor TZipWindow.Init(R: TRect; const ZipFileName: PathStr);
begin
  inherited Init(R, ZipFilename, wnNoNumber);
  Options := Options or ofTileable;
  GetExtent(R);
  R.Grow(-1, -1);
  Insert(New(PZipViewer, Init(R,
    StandardScrollBar(sbHorizontal + sbHandleKeyboard),
    StandardScrollBar(sbVertical + sbHandleKeyboard), ZipFilename)));
end;

{ TTextDialog }
constructor TZipDialog.Init(R: TRect; const ZipFileName: PathStr);
begin
  inherited Init(R, ZipFilename);
  Flags := Flags and not wfMove;
  GetExtent(R);
  R.Grow(-1, -1);
  Insert(New(PZipViewer, Init(R,
    StandardScrollBar(sbHorizontal + sbHandleKeyboard),
    StandardScrollBar(sbVertical + sbHandleKeyboard), ZipFilename)));
end;

procedure RegisterZViewer;
begin
  RegisterType(RZipViewer);
  RegisterType(RZipWindow);
end;

begin
  GenZipLines := NIL;
end.
